unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    SaveDialog1: TSaveDialog;
    MainGroup: TGroupBox;
    NotUsed1: TSpeedButton;
    SauverBtn: TSpeedButton;
    LetterComboBox: TComboBox;
    FonctionComboBox: TComboBox;
    CommandesListBox: TListBox;
    SayEdit: TEdit;
    DeleteBtn: TSpeedButton;
    DeleteAllBtn: TSpeedButton;
    UserEdit: TEdit;
    LoadBtn: TSpeedButton;
    OpenDialog1: TOpenDialog;
    RessourcesExternesGroupe: TGroupBox;
    TextList: TListBox;
    CommandesListe: TListBox;
    RefreshBtn: TButton;
    AddPersoBtn: TButton;
    FonctionUserBox: TComboBox;
    ParamsUserEdit: TEdit;
    AddPersoBtn1: TSpeedButton;
    SpeedButton1: TSpeedButton;
    NewFctBtn: TSpeedButton;
    AddBtn: TSpeedButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    AddPredefBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure LetterComboBoxChange(Sender: TObject);
    procedure FonctionComboBoxChange(Sender: TObject);
    procedure SauverBtnClick(Sender: TObject);
    procedure CommandesListBoxDblClick(Sender: TObject);
    procedure DeleteAllBtnClick(Sender: TObject);
    procedure LoadBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure TextListClick(Sender: TObject);
    procedure AddPersoBtnClick(Sender: TObject);
    procedure AddPersoBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure NewFctBtnClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure AddPredefBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

  TmpInteger: integer;

  TmpString, FonctionSelected, LetterSelected: string;

  OpenF: TextFile;

const
  AppName = 'Quake Macros Maker ';                                      // Attribution du nom de l'application
  Version = 'v0.4b ';                                                   //             de la version
  Auteur = '(c) Rudy Dullier 1997';                                     //             du copyright
  AuteurShort = '(c) Dullier 1997';                                     //             du copyright court

implementation

{$R *.DFM}

//--------------------------------------------------------------------- Routine de dmarrage d'application via Form1
procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.Title := AppName + Version;                               // Affichage Prog + Version ds la Task Bar
  MainForm.Caption := AppName + Version + Auteur;                       // Affichage Prog + Version + Auteur ds Caption

  LetterSelected := 'a';                                                // Attribution d'une touche d'attente pour la suite
  FonctionSelected := 'echo Cette touche ne sert pas';                  // Attribution d'un message par dfaut

  AssignFile(OpenF, ExtractFilePath(Application.ExeName)+'CONFIG');     // Ouverture du fichier CONFIG
  Reset(OpenF);                                                         // Reset du fichier

  TextList.Clear;                                                       // Effacement de "TextList"
  CommandesListe.Clear;                                                 // Effacement de "CommandesList"

  while not eof(OpenF) do                                               // Tant que le fichier n'est pas EOF
  begin
    Readln(OpenF, TmpString);                                             // Lire une ligne
    TextList.Items.Add(TmpString);                                        // L'ajouter dans "TextList"
    Readln(OpenF, TmpString);                                             // Lire une ligne
    CommandesListe.Items.Add(TmpString);                                  // L'ajouter dans "CommandesListe"
  end;
  CloseFile(OpenF);                                                     // Fermeture du fichier

  TmpInteger := 1;                                                      // Attribution de la valeur 1  TmpInteger

  MainForm.Width :=
                    MainGroup.Left
                    + MainGroup.Width
                    + MainGroup.Left * 2
                    + RessourcesExternesGroupe.Width
                    + MainGroup.Left;
end;
//--------------------------------------------------------------------- Routine en cas de changement de lettre
procedure TMainForm.LetterComboBoxChange(Sender: TObject);
begin
with LetterComboBox do                                                  // Utiliser l'lment "LetterComboBox"
begin                                                                     // Attribution des touches + conversion en QWERTY
  if Text = 'a' then LetterSelected := 'q';
  if Text = 'b' then LetterSelected := 'b';
  if Text = 'c' then LetterSelected := 'c';
  if Text = 'd' then LetterSelected := 'd';
  if Text = 'e' then LetterSelected := 'e';
  if Text = 'f' then LetterSelected := 'f';
  if Text = 'g' then LetterSelected := 'g';
  if Text = 'h' then LetterSelected := 'h';
  if Text = 'i' then LetterSelected := 'i';
  if Text = 'j' then LetterSelected := 'j';
  if Text = 'k' then LetterSelected := 'k';
  if Text = 'l' then LetterSelected := 'l';
  if Text = 'm' then LetterSelected := ',';
  if Text = 'n' then LetterSelected := 'n';
  if Text = 'o' then LetterSelected := 'o';
  if Text = 'p' then LetterSelected := 'p';
  if Text = 'q' then LetterSelected := 'a';
  if Text = 'r' then LetterSelected := 'r';
  if Text = 's' then LetterSelected := 's';
  if Text = 't' then LetterSelected := 't';
  if Text = 'u' then LetterSelected := 'u';
  if Text = 'v' then LetterSelected := 'v';
  if Text = 'w' then LetterSelected := 'z';
  if Text = 'x' then LetterSelected := 'x';
  if Text = 'y' then LetterSelected := 'y';
  if Text = 'z' then LetterSelected := 'w';

  if Text = '1' then LetterSelected := '1';
  if Text = '2' then LetterSelected := '2';
  if Text = '3' then LetterSelected := '3';
  if Text = '4' then LetterSelected := '4';
  if Text = '5' then LetterSelected := '5';
  if Text = '6' then LetterSelected := '6';
  if Text = '7' then LetterSelected := '7';
  if Text = '8' then LetterSelected := '8';
  if Text = '9' then LetterSelected := '9';
  if Text = '0' then LetterSelected := '0';

  if Text = 'TAB'   then LetterSelected := 'TAB';                         // Touches spciales
  if Text = 'ENTER' then LetterSelected := 'ENTER';
  if Text = 'SHIFT' then LetterSelected := 'SHIFT';
  if Text = 'CTRL'  then LetterSelected := 'CTRL';
  if Text = 'ALT'   then LetterSelected := 'ALT';
  if Text = 'SPACE' then LetterSelected := 'SPACE';

  if Text = 'PGUP'  then LetterSelected := 'PGUP';
  if Text = 'PGDN'  then LetterSelected := 'PGDN';
  if Text = 'HOME'  then LetterSelected := 'HOME';
  if Text = 'END'   then LetterSelected := 'END';
  if Text = 'INS'   then LetterSelected := 'INS';
  if Text = 'DEL'   then LetterSelected := 'DEL';
  if Text = 'ESC'   then LetterSelected := 'ESC';
  if Text = 'PAUSE' then LetterSelected := 'PAUSE';

  if Text = 'UPARROW'    then LetterSelected := 'UPARROW';
  if Text = 'DOWNARROW'  then LetterSelected := 'DOWNARROW';
  if Text = 'LEFTARROW'  then LetterSelected := 'LEFTARROW';
  if Text = 'RIGHTARROW' then LetterSelected := 'RIGHTARROW';

  if Text = 'MOUSE1' then LetterSelected := 'MOUSE1';                     // Boutons de la souris
  if Text = 'MOUSE2' then LetterSelected := 'MOUSE2';
  if Text = 'MOUSE3' then LetterSelected := 'MOUSE3';

  if Text = 'F1'  then LetterSelected := 'F1';
  if Text = 'F2'  then LetterSelected := 'F2';
  if Text = 'F3'  then LetterSelected := 'F3';
  if Text = 'F4'  then LetterSelected := 'F4';
  if Text = 'F5'  then LetterSelected := 'F5';
  if Text = 'F6'  then LetterSelected := 'F6';
  if Text = 'F7'  then LetterSelected := 'F7';
  if Text = 'F8'  then LetterSelected := 'F8';
  if Text = 'F9'  then LetterSelected := 'F9';
  if Text = 'F10' then LetterSelected := 'F10';
  if Text = 'F11' then LetterSelected := 'F11';
  if Text = 'F12' then LetterSelected := 'F12';

  if Text = '+'  then LetterSelected := '+';                              // Touches  charactres spciaux
  if Text = '-'  then LetterSelected := '-';
  if Text = '/'  then LetterSelected := '/';
  if Text = '*'  then LetterSelected := '*';
  if Text = '='  then LetterSelected := '=';
  if Text = ')'  then LetterSelected := '+';
  if Text = ';'  then LetterSelected := ',';
  if Text = ':'  then LetterSelected := '.';
  if Text = '<'  then LetterSelected := '\';
  if Text = ''  then LetterSelected := ',';
  if Text = ''  then LetterSelected := '~';

  if Text = 'AUX1'  then LetterSelected := 'AUX1';                        // Boutons auxiliaires (joysticks,...)
  if Text = 'AUX2'  then LetterSelected := 'AUX2';
  if Text = 'AUX3'  then LetterSelected := 'AUX3';
  if Text = 'AUX4'  then LetterSelected := 'AUX4';
  if Text = 'AUX5'  then LetterSelected := 'AUX5';
  if Text = 'AUX6'  then LetterSelected := 'AUX6';
  if Text = 'AUX7'  then LetterSelected := 'AUX7';
  if Text = 'AUX8'  then LetterSelected := 'AUX8';
end;
end;
//--------------------------------------------------------------------- Routine en cas de changement de fonction
procedure TMainForm.FonctionComboBoxChange(Sender: TObject);
begin
with FonctionComboBox do                                                 // Utiliser l'lment "FonctionComboBox"
begin
  FonctionSelected := 'echo Cette touche ne sert pas';
  if Text = 'Avancer'              then FonctionSelected := '+forward';  // Attribution des fonctions selon le texte
  if Text = 'Reculer'              then FonctionSelected := '+back';
  if Text = 'Tourner  gauche'     then FonctionSelected := '+left';
  if Text = 'Tourner  droite'     then FonctionSelected := '+right';
  if Text = 'Courrir'              then FonctionSelected := '+speed';
  if Text = 'Dplacement lattral' then FonctionSelected := '+strafe';
  if Text = 'Tirer'                then FonctionSelected := '+attack';
  if Text = 'Sauter'               then FonctionSelected := '+jump';
  if Text = 'Dplacement  droite' then FonctionSelected := '+moveright';
  if Text = 'Dplacement  gauche' then FonctionSelected := '+moveleft';
  if Text = 'Dplacement haut'     then FonctionSelected := '+moveup';
  if Text = 'Dplacement bas'      then FonctionSelected := '+movedown';

  if Text = 'Parler'               then FonctionSelected := 'say';
  if Text = 'Parler  l''quipe'   then FonctionSelected := 'say_team';

  if Text = 'Pinger'               then FonctionSelected := 'ping';

  if Text = 'Verouillage clavier'  then FonctionSelected := '+klook';
  if Text = 'Verouillage souris'   then FonctionSelected := '+mlook';
  if Text = 'Regarder en haut'     then FonctionSelected := '+lookup';
  if Text = 'Regarder en bas'      then FonctionSelected := '+lookdown';

  if Text = 'Scores'               then FonctionSelected := '+showscores';

  if Text = 'Hache'                then FonctionSelected := 'impulse 1';
  if Text = 'Shootgun simple'      then FonctionSelected := 'impulse 2';
  if Text = 'Double Shootgun'      then FonctionSelected := 'impulse 3';
  if Text = 'Mitrailleuse  clous' then FonctionSelected := 'impulse 4';
  if Text = 'Super mitrallieuse'   then FonctionSelected := 'impulse 5';
  if Text = 'Lance-Grenades'       then FonctionSelected := 'impulse 6';
  if Text = 'Lance-Roquettes'      then FonctionSelected := 'impulse 7';
  if Text = 'Thunderbolt'          then FonctionSelected := 'impulse 8';
  if Text = 'Arme suivante'        then FonctionSelected := 'impulse 10';
  if Text = 'Arme prcdente'      then FonctionSelected := 'impulse 12';

  if Text = 'Agrandir affichange'  then FonctionSelected := 'sizeup';
  if Text = 'Rduire affichange'   then FonctionSelected := 'sizedown';
  if Text = 'Console'              then FonctionSelected := 'toggleconsole';
  if Text = 'Menu'                 then FonctionSelected := 'togglemenu';
  if Text = 'Mode dialogue'        then FonctionSelected := 'messagemode';

  if Text = 'Aide'                 then FonctionSelected := 'help';
  if Text = 'Menu sauver'          then FonctionSelected := 'menu_save';
  if Text = 'Menu charger'         then FonctionSelected := 'menu_load';
  if Text = 'Sauver rapidement'    then FonctionSelected := 'echo Quicksaving...; wait; save quick';
  if Text = 'Charger rapidement'   then FonctionSelected := 'echo Quickloading...; wait; load quick';
  if Text = 'Menu options'         then FonctionSelected := 'menu_options';
  if Text = 'Menu multijoueurs'    then FonctionSelected := 'menu_multiplayer';
  if Text = 'Quitter'              then FonctionSelected := 'quit';
  if Text = 'Zoom'                 then FonctionSelected := 'zoom';
  if Text = 'Capture d''cran'     then FonctionSelected := 'screenshot';

  if Text = 'Centrer la vue'       then FonctionSelected := 'centerview';
  if Text = 'Forcer le centrage'   then FonctionSelected := 'force_centerview';
  if Text = 'Pause'                then FonctionSelected := 'pause';

  if Text = 'Dfini par l''utilisateur'    then FonctionSelected := 'User';
  if Text = 'Free Look -By Shutting Down-' then FonctionSelected := 'Free-Look';

end;
end;
//--------------------------------------------------------------------- Routine de sauvegarde de la configuration
procedure TMainForm.SauverBtnClick(Sender: TObject);
var
  StopIndex, StartIndex: integer;
begin
  if CommandesListBox.Items.Count > 0 then                              // Si objets
    if SaveDialog1.Execute then                                           // Si SaveDialog russit
    begin
      Memo1.Clear;                                                        // Effacement de "Memo1"
      Memo1.Lines.Add('// Fichier macro cr grce au ' + AppName + Version); // Ajout de string de texte
      Memo1.Lines.Add('//                             ' + Auteur);
      Memo1.Lines.Add('// Ce programme peut tre obtenu gratuitement via:');
      Memo1.Lines.Add('//   Mon E-Mail: sky40679@skynet.be');
      Memo1.Lines.Add('//   Mon site: http://users.skynet.be/sky40679/');

      CommandesListBox.ItemIndex := 0;                                    // Premier objet
      StopIndex := CommandesListBox.Items.Count - 1;                      // Stop index = Total des objets -1
      for StartIndex := 0 to StopIndex do                                 // De 0  StopIndex
      begin
        Memo1.Lines.Add(CommandesListBox.Items[CommandesListBox.ItemIndex]);// Ajouter la ligne au "Mmo1"
        CommandesListBox.ItemIndex := CommandesListBox.ItemIndex + 1;       // Select de l'objet suivant
      end;

      Memo1.Lines.SaveToFile(SaveDialog1.FileName);                       // Sauver texte du Mmo
      Memo1.Clear;                                                        // Effacement de "Memo1"
    end;
end;
//--------------------------------------------------------------------- Routine en cas de double clique
procedure TMainForm.CommandesListBoxDblClick(Sender: TObject);
begin
  CommandesListBox.Items.Delete(CommandesListBox.ItemIndex);            // Effacer objet d'Item Index courant
end;
//--------------------------------------------------------------------- Routine du bouton d'effacement total
procedure TMainForm.DeleteAllBtnClick(Sender: TObject);
begin
  CommandesListBox.Clear;                                               // Effacer "CommandesListBox"
  Memo1.Clear;                                                          // Effacer "Memo1"
end;
//--------------------------------------------------------------------- Routine en cas de pression du bouton Charger
procedure TMainForm.LoadBtnClick(Sender: TObject);
var                                                                     // Variable OpenF
  OpenF: TextFile;
begin
  if OpenDialog1.Execute then                                           // Si OpenDialog russit
  begin
    CommandesListBox.Clear;                                               // Effacer Liste

    AssignFile(OpenF, OpenDialog1.FileName);                              // Ouverture du fichier
    Reset(OpenF);                                                         // Reset du fichier
    while not eof(OpenF) do                                               // Si pas EOF
    begin
      Readln(OpenF, TmpString);                                             // Lire ligne
      CommandesListBox.Items.Add(TmpString);                                // L'ajouter  la liste
    end;
    CloseFile(OpenF);                                                     // Fermer fichier
  end;
end;
//--------------------------------------------------------------------- Routine du bouton "Refrech"
procedure TMainForm.RefreshBtnClick(Sender: TObject);
begin
  AssignFile(OpenF, ExtractFilePath(Application.ExeName)+'CONFIG');     // Ouverture du fichier
  Reset(OpenF);                                                         // Reset du fichier

  TextList.Clear;                                                       // Effacement de "TextList"
  CommandesListe.Clear;                                                 // Effacement de CommandesListe"

  while not eof(OpenF) do                                               // Si pas EOF
  begin
    Readln(OpenF, TmpString);                                             // Lire ligne
    TextList.Items.Add(TmpString);                                        // L'ajouter  "TextList"
    Readln(OpenF, TmpString);                                             // Lire ligne
    CommandesListe.Items.Add(TmpString);                                  // L'ajouter  "CommandesListe"
  end;
  CloseFile(OpenF);                                                     // Fermeture du fichier
end;
//--------------------------------------------------------------------- Si click dans TextList
procedure TMainForm.TextListClick(Sender: TObject);
begin
  CommandesListe.ItemIndex := TextList.ItemIndex;                       // Synchronisation de l'Item Index des 2 listes
end;
//--------------------------------------------------------------------- Routine du bouton d'ajout de fct perso
procedure TMainForm.AddPersoBtnClick(Sender: TObject);
begin
                                                                        // bind "touche" "fonction" 
  CommandesListBox.Items.Add(                                           // Ajouter une ligne contenant  CommandesListe
                             'bind "'                                   //  bind "
                             + LetterSelected                           //  touche
                             + '" "'                                    //  " "
                             + CommandesListe.Items[CommandesListe.ItemIndex] // Fonction en cours selon le texte
                             + '"'                                      // "
                             );
end;
//--------------------------------------------------------------------- Routine du bouton d'ajout de fonction Perso
procedure TMainForm.AddPersoBtn1Click(Sender: TObject);
begin
                                                                        // fonction params
  CommandesListBox.Items.Add(                                           // Ajouter une ligne  CommandesListe
                             FonctionUserBox.Items[FonctionUserBox.ItemIndex] // fontion
                             + ' '                                            
                             + ParamsUserEdit.Text                            // paramtre
                             );
end;
//--------------------------------------------------------------------- Bouton de redimensionnement
procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  if TmpInteger = 1 then                                                 // Si TmpInteger = 1
  begin
    TmpInteger := 0;                                                       // TmpInteger = 0
    MainForm.Caption := AppName + Version + AuteurShort;                   // Caption = style court
    MainForm.Width :=
                      RessourcesExternesGroupe.Left
                      + MainGroup.Left;
    MainForm.Position := poScreenCenter;                                   // Repositionement au centre
  end
  else                                                                     // si TmpInteger <> 1
  begin
    TmpInteger := 1;                                                       // TmpInteger = 1
    MainForm.Caption := AppName + Version + Auteur;                        // Caption = style complet
    MainForm.Width :=
                      MainGroup.Left
                      + MainGroup.Width
                      + MainGroup.Left * 2
                      + RessourcesExternesGroupe.Width
                      + MainGroup.Left;
    MainForm.Position := poScreenCenter;                                   // Repositionement au centre
  end;
end;
//--------------------------------------------------------------------- Routine d'ajout de fonction simple
procedure TMainForm.NewFctBtnClick(Sender: TObject);
begin
  CommandesListBox.Items.Add(                                           // Ajouter le texte de UserEdit  CommandesListe
                             UserEdit.Text
                             );
end;
//--------------------------------------------------------------------- Routine du bouton d'ajout
procedure TMainForm.AddBtnClick(Sender: TObject);
begin
  if LetterComboBox.Text <> 'Choisissez une touche' then                // Si Lettre active
     if FonctionComboBox.Text <> 'Choisissez une fonction' then           // Si Fonction active
        if FonctionSelected = 'say_team' then                               // Si Fonction = Say_Team
           CommandesListBox.Items.Add(
                                      'bind "'
                                      + LetterSelected
                                      + '" "'
                                      + FonctionSelected
                                      + ' '
                                      + SayEdit.Text
                                      + '"'
                                      );

        if FonctionSelected = 'say' then                                    // Si fct = Say
           CommandesListBox.Items.Add(
                                      'bind "'
                                      + LetterSelected
                                      + '" "'
                                      + FonctionSelected
                                      + ' '
                                      + SayEdit.Text
                                      + '"'
                                      );

        if FonctionSelected = 'zoom' then                                   // Si fct = Zoom
        begin
           CommandesListBox.Items.Add(
                                      'alias zoom_in "sensitivity 2;fov 90;wait;fov 70;wait;fov 50;wait;fov 30;wait;fov 10;wait;fov 5; alias zoom zoom_out"'
                                       );
           CommandesListBox.Items.Add(
                                      'alias zoom_out "sensitivity 4;fov 5;wait;fov 10;wait;fov 30;wait;fov 50;wait;fov 70;wait;fov 90;alias zoom zoom_in; sensitivity 7;"'
                                      );
           CommandesListBox.Items.Add(
                                      'bind "'
                                      + LetterSelected
                                      + '" "zoom"'
                                      );

        end;

        if FonctionSelected = 'Free-Look' then                              // Si fct = Free-Look
        begin
           CommandesListBox.Items.Add(
                                      'alias Free-Look looklock_on'
                                      );
           CommandesListBox.Items.Add(
                                      'alias looklock_on "alias Free-Look looklock_off;+mlook;echo Look-lock active!"'
                                      );
           CommandesListBox.Items.Add(
                                      'alias looklock_off "alias Free-Look looklock_on;-mlook;echo Look-lock desactive!"'
                                      );
           CommandesListBox.Items.Add(
                                      'bind "'
                                      + LetterSelected
                                      + '" "Free-Look"'
                                      );
        end;

        if FonctionSelected <> 'say' then                               // Si fct <> say
        if FonctionSelected <> 'say_team' then                          //           say_team
        if FonctionSelected <> 'zoom' then                              //           zoom
        if FonctionSelected <> 'Free-Look' then                         //           Free-Look
           CommandesListBox.Items.Add(                                    // Ajouter la fonction telle quelle
                                      'bind "'
                                      + LetterSelected
                                      + '" "'
                                      + FonctionSelected
                                      + '"'
                                      );
end;
//--------------------------------------------------------------------- Routine d'ajout prfrentiel
procedure TMainForm.AddPredefBtnClick(Sender: TObject);
begin
  CommandesListBox.Items.Add(                                           
                             FonctionUserBox.Text
                             + ' "'
                             + ParamsUserEdit.Text
                             + '" "'
                             + CommandesListe.Items[CommandesListe.ItemIndex]
                             + '"'
                             );
end;
//---------------------------------------------------------------------
end.
//---------------------------------------------------------------------

